IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'dbo.CPJ_Verificacion_Saldos_Clientes') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE dbo.[CPJ_Verificacion_Saldos_Clientes]
END
GO

CREATE PROCEDURE [dbo].[CPJ_Verificacion_Saldos_Clientes]  @pJsonRecibido VARCHAR(8000)	 

AS

DECLARE 	@pFecha_Desde		DATETIME,
			@pFecha_Hasta		DATETIME,
			@pAgrupaCli         TINYINT


SET @pFecha_Desde				= ISNULL(CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJsonRecibido,'Fecha_Desde')),GETDATE())
SET @pFecha_Hasta				= ISNULL(CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJsonRecibido,'Fecha_Hasta')),GETDATE())
SET @pAgrupaCli			     	= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJsonRecibido,'AgrupaCli')),0)

--VERSION: 10/02/2022
        CREATE TABLE #Verificacion (id_cliente INT , id_cliente_Ref INT , Rescta DECIMAL(16,2),Deuda Decimal(16,2),Diferencia Decimal(16,2) )

		INSERT INTO #Verificacion
		select C.id_cliente,isnull(K.id_cliente_Ref,k.id_cliente) as cliente_Ref, sum(ISNULL(c.imp_total,0) * t.compromete_factura * ISNULL(c.cotizacion,1)) ,0,0 
		from cbtes c, cbtes_tipos t, Clientes K 
		where c.id_tipo_cbte = t.Id_Tipo_Cbte
		and c.id_cliente = K.id_cliente
		and compromete_factura in (1,-1) 
		and c.Id_Estado_Cbte not in (0,3)
		and c.id_cliente > 1
		and c.Id_Cond_Pago <> 1
		group by  c.id_cliente,isnull(K.id_cliente_Ref,k.id_cliente)  
		 

		Update #Verificacion SET id_cliente_Ref = Id_Cliente where id_cliente_Ref = 0


		select c.id_cliente,isnull(K.id_cliente_Ref,k.id_cliente) as Cliente_Ref,sum(ISNULL(c.imp_total,0) * ISNULL(c.cotizacion,1) ) as recibos
		into #Recibos
		from cbtes c, cbtes_tipos t, Clientes K 
		where c.id_tipo_cbte = t.Id_Tipo_Cbte
		and c.id_cliente = K.id_cliente
		and compromete_recibos in (1,-1)
		and c.Id_Estado_Cbte not in (0,3)
		and c.id_cliente > 1
		group by  c.id_cliente,isnull(K.id_cliente_Ref,k.id_cliente)  

		Update #Recibos SET Cliente_Ref = Id_Cliente where Cliente_Ref = 0

		INSERT INTO #Verificacion
		SELECT 



		select c.id_cliente,isnull(K.id_cliente_Ref,k.id_cliente) as Cliente_Ref,sum(t.importe*c.cotizacion) as importe, sum(t.saldo*c.cotizacion) as saldo
		Into #CtaCte
		from  clientes_ctacte t, Cbtes C, Clientes K 
		where c.id_trans = t.id_trans
		and c.id_cliente = K.id_cliente
		and t.Id_Estado_Cbte not in (0,3)
		and c.id_cliente >1
		group by  c.id_cliente,isnull(K.id_cliente_Ref,k.id_cliente)  

		Update #CtaCte SET Cliente_Ref = Id_Cliente where Cliente_Ref = 0


		Update #Verificacion set Rescta = C.Rescta - R.Recibos from #Verificacion C, #Recibos R Where C.Id_Cliente = R.Id_Cliente And C.Cliente_Ref = R.Cliente_Ref

		Update #Verificacion set Deuda = R.Importe from #Verificacion C, #CtaCte R Where C.Id_Cliente = R.Id_Cliente And C.Cliente_Ref = R.Cliente_Ref

		Update #Verificacion set Diferencia = Rescta - Deuda  

        IF @pAgrupaCli <> 1
		   BEGIN
			  SELECT v.id_cliente,c.razon_social,SUM(Rescta) AS Rescta ,SUM(Deuda) AS Deuda,SUM(Diferencia) AS Diferencia 
			  INTO #Resultado
			  FROM #Verificacion V,Clientes C 
			  where c.id_cliente = V.Id_cliente GROUP BY v.id_cliente,c.razon_social order by C.Razon_Social

			  SELECT * FROM #Resultado WHERE Diferencia <> 0
			  DROP TABLE #Resultado
			  
		   END
		ELSE
		   BEGIN
			  SELECT v.Cliente_Ref,c.razon_social,SUM(Rescta) AS Rescta ,SUM(Deuda) AS Deuda,SUM(Diferencia) AS Diferencia 
			  INTO #Resultado2
			  FROM #Verificacion V,Clientes C 
			  where c.id_cliente = V.Cliente_Ref GROUP BY v.Cliente_Ref,c.razon_social order by C.Razon_Social

			  SELECT * FROM #Resultado2 WHERE Diferencia <> 0
			  DROP TABLE #Resultado2
		   END		
		   
        

		
 		DROP TABLE #Verificacion
		DROP TABLE #Recibos
		DROP TABLE #CtaCte


	--	CPJ_Verificacion_Saldos_Clientes '{}' 